function BUS:n5_bus_set_have_one_full( b )
	--aaa.print_method()
	if b == false then
		--aaa.debug.print_traceback()
	end
	self.b_n5_have_one_full = b
end

function BU:n5_really_flip_size()
	--was also setting a .9 factor to full page
	--self:flip_full_page( self.__images and .9 or nil )
	self:set_window_state( "flip_full" )

	chanel_n5.bu_flipping = self
	local bus = self:get_bus_up()
	if self:is_full_page() then
		if self.verbose >= 1 then self:print_debug( "Now full page" ) end
		if self:is_video() or self.__images then
			self:set_mobile( true )
			self:set_inertia( true )
			self:play_video()
			chanel_n5:show_bottle_back_but( false )
		else
			self:set_mobile( false )
			self:set_inertia( false )
			chanel_n5:show_bottle_back_but( true )
		end
		bus:n5_bus_set_have_one_full( true )
		self:set_ui_active( false )
	else
		if self.verbose >= 1 then self:print_debug( "got small" ) end
		self:set_mobile( true )
		self:set_inertia( true )
		bus:n5_bus_set_have_one_full( false )
		self:set_ui_active( true )
		chanel_n5:show_bottle_back_but( true )
	end
end
function BU:n5_can_flip_size()
	if self.verbose >= 1 then self:print( chanel_n5.b_click_simple, chanel_n5.bu_flipping == nil, not self:is_transfo_inter() ) end
	local ret = chanel_n5.b_click_simple and chanel_n5.bu_flipping == nil and (not self:is_transfo_inter())
	if ret then
		if self:is_full_page() then
			if self.verbose >= 1 then self:print( "self:is_full_page()" ) end
			ret = true
		else
			local bus = self:get_bus_up()
			if self.verbose >= 1 then self:print( "not self:is_full_page()  "..(not bus.b_n5_have_one_full) ) end
			ret = not bus.b_n5_have_one_full
		end
	end
	return ret
end
function BU:n5_bu_check_full_page()
	local sx,sy = self:get_sxy()
	if sy > 4.55 then
		self:n5_really_flip_size()
	end
end
function BU:n5_next_media()
	self:n5_bu_check_full_page()
	self:next_media()
end
function BU:n5_prev_media()
	self:n5_bu_check_full_page()
	self:prev_media()
end

local function set_n5_bu( bu )
	--bu:set_method_on_click_double( bu, "n5_click_double" )
	--bu:set_method_on_click( bu, "n5_click_simple" )
	bu.do_click_down	=	BU.n5_bu_do_click_down
	bu.do_click_up		=	BU.n5_bu_do_click_up
end

function BU:n5_bu_do_click_down( x,y )
	BU.do_click_down( self, x,y )
	if self.verbose >= 1 then aaa.print_method() end
	local bx, by = self:convert_xy_local_to_bus_up( x,y )
	local n5 = self.n5
	if not n5 then
		self.n5 = {}
		n5 = self.n5
	end
	--	coor in the bus up
	n5.bx = bx
	n5.by = by
	--	coor in the bu [-.5,.5]
	n5.x = x
	n5.y = y

	set_n5_bu( self )
end

function BU:n5_bu_do_click_up( x, y )
	BU.do_click_up( self, x, y )
	local bx,by = self.__blob_cur[1].x, self.__blob_cur[1].y
	local n5 = self.n5
	if self.verbose >= 1 then self:print( "n5_bu_do_click_up() blob "..bx..", "..by ) end

	local b_did_it
	if n5 then
		if self:n5_can_flip_size() then
			--if self.verbose >= 0 then self:print( "--------------------- "..n5.x..", "..n5.y ) end
			if self:is_video() and not self:is_video_button() and n5.y < -.3 then
				self:set_video_button( true )
			else
				local dist = V2.dist_from_xyxy( bx, by, n5.bx, n5.by )
				--self:print( "do_click_up() for n5 "..x..", "..y )
				--self:print( "do_click_up() for n5 "..dist )
				if dist <= .1 then
					self:n5_really_flip_size()
					b_did_it = true
				end
			end
		end
	end
	if not b_did_it and self.__ui_interaction_type == "move" then
		if self:is_full_page() then
			local bus = self:get_bus_up()
			bus:n5_bus_set_have_one_full( false )
		end
	end

	self.n5 = nil

	--local blob = ga:get_blobs():find_by_id( self.__blob_start[1].id )
	--self:print( "do_click_up() for n5 "..x..", "..y )
end


--
--	MBRO
--
if CLASS.DECLARE( "MBRO" ) then
	MBRO:set_class_status_doc(	"chanel",
								"used in chanel app" )
end

function MBRO:create( name )
	return MBRO:create_instance( name )
end
function MBRO:update_before()
	--	aaa.print( "MBRO:update_before()" )
end
function MBRO:update_after()
	--	aaa.print( "MBRO:update_after()" )
end
local	function bus_reset_phase_1( bus )
	bus:apply_fn_down( function(self)
		if self:is_full_page() then
			self:n5_really_flip_size()
		end
	end )
end
local	function bus_reset_phase_2( bus )
	bus:apply_fn_down( function(self)
		--	CLOSE BU
		if self:is_video() then
			self:place_video_at_start()
		end
		if self.__images then
			self:set_media_index( 1 )
		end
	end )
end

function MBRO:reload_pos()
	--self:print( "reload_pos()" )
	local bus = self.bus
	bus:n5_bus_set_have_one_full( false )	--	not needed but a secu
	bus:apply_fn_down(
		function(self)
			local bus = self:get_bus_down()
			if bus then
				if self:is_full_page() then
					self:n5_really_flip_size()
				else
				end
				--self:print( "reload_pos() "..i.." "..self.." "..bus_down )
				--	CLOSE all the full page
				bus_reset_phase_1( bus )
				--	RELOAD POS TO SAVED ONE
				bus:push()	--todo push/pop should be somewhere else
					bus:load_bu_pos()
				bus:pop()
				bus:n5_bus_set_have_one_full( false )	--	not needed but a secu
				--	SET ALL THE VIDEO AT START
				bus_reset_phase_2( bus )
				--	CLOSE BU
			end
		end
		)
end

function BU:n5_draw_back_text()
	gol.set_default()

	gol.set_texture_dim( 2 )
	gol.bind_texture( self:get_texture_bind_2d() )
	gol.color_white()
	local inter = self:get_bu_up().n5_inter
	--self:print( "titi "..inter )
	inter = inter or 1.
	self:gol_draw_rect_uv_size( interpolate( chanel_n5.l1_word_scale or 1, 1, inter ) )
	--self:print( chanel_n5.l1_word_scale )
end
local	function n5_draw_back_text( bu )
	bu:n5_draw_back_text()
end

function MBRO:draw_but( bu )
	gol.set_default()
	gol.color_white()
	--self:draw_rect_plain()
	aaa.bind_draw_rect( bu:get_texture_bind_to_draw(),	-.25, -.25, .25, .25 )
	if false then
		gol.color_green()
		--maatex gol.set_texture_dim( 0 )
		self:gol_draw_rect_line()
	end
end

local function count_image_video( dir_name_or_table )
	local	t_file
	local	b_table

	if type( dir_name_or_table ) == "string" then
		--if self.verbose >= 1 then self:print( "add_files(\""..dir_name_or_table.."\" )" ) end
		t_file = aaa.dir.get_files( dir_name_or_table )
		if not t_file then return 0, 0 end
	else
		t_file = dir_name_or_table
		b_table = true
	end

	local	nb_video = 0
	local	nb_image = 0
	for t, u in pairs( t_file ) do
		--self:print_debug( "file : "..t.." .. "..u )
		local filename = b_table and u or dir_name_or_table.."/"..u
		if MEDIA.is_name_image( filename ) then
			nb_image = nb_image + 1
		elseif MEDIA.is_name_video( filename ) then
			nb_video = nb_video + 1
		else
		end
	end
	--if nb > 0 then
		aaa.print_debug( "img "..nb_image.." vid"..nb_video )
	--end
	return nb_image, nb_video
end

function MBRO:define_pages_inside( bus_name, dir_name_or_table, background_name )
	local bu
	local noms

	local bus = BUS:create( "MBRO_BUS_"..bus_name )

	local function add_but( bus, name, image_name, x, rot, bu_target, method_name )
		local bu = bus:add_button_image( name, {x,0, 1,1, rot}, image_name )
			bu:set_pos_load_save( false )
			bu:set_method_on_click(			bu_target, method_name )
			bu:set_method_on_click_double(	bu_target, method_name )
			bu:set_method(	"draw_custom",	self, "draw_but", bu )
			--bu:set_method( "click", obj, method_name, arg1, arg2, arg3, arg4 )
			bu:set_dplane(42)
		return bu
	end

	local bu_media = nil
	local sx = 8
	local sy = 4.5
	bus:set_transfo( 16,9, sx,sy )

	bus:init_begin()
	bus:set_bu_pos_load_save(true)
	bus.b_video_only_one_playing = true

		self:add_dir_in_dir( bus, dir_name_or_table )

		local nb_i, nb_v = count_image_video( dir_name_or_table )
		if nb_v == 0 then --	No video : add all images ( was egeries chanel N5
			if nb_i ~= 0  then
				local t_file = aaa.dir.get_files( dir_name_or_table )
				if t_file then
					if MEDIA.is_name_image( t_file[1] ) then
						bu_media = bus:add_image( t_file[1], {0,-1.5, nil,2}, dir_name_or_table.."/"..t_file[1], true )

						for i=2, #t_file do
							bu_media:add_image( t_file[i], dir_name_or_table.."/"..t_file[i] )
						end
						set_n5_bu( bu_media )
						bu_media:set_border_line_color( {1, 1, 1, 1} )
						bu_media:set_border_line( true )
						bus.n5_visibility_flip_list = { bu_media }
						bu_media.dplane = -42

						local bu_b
						bu_b = add_but( "prev", bus, dir_name_or_table.."/../Next.png", -3.8, 0.5,	bu_media, "n5_prev_media" )
							bus.n5_visibility_flip_list[2] = bu_b

						bu_b = add_but( "next", bus, dir_name_or_table.."/../Next.png", 3.8, 0,		bu_media, "n5_next_media" )
							bus.n5_visibility_flip_list[3] = bu_b

					end
				end
			end
		else
			if nb_i ~= 0  then
				bus:add_dir_no_recur( dir_name_or_table, true, true, false )
				for i=1,bus:get_bu_nb()	 do
					bu = bus:get_bu( i )
					if bu:is_video() then
						set_n5_bu( bu )
					else
						set_n5_bu( bu )
					end
				end
			else
				bus:add_dir_no_recur( dir_name_or_table, false, true, false )
				for i=1,bus:get_bu_nb()	 do
					bu = bus:get_bu( i )
					if bu:is_video() then
						set_n5_bu( bu )
					end
				end
			end
		end

		bus:set_page( 0 )
		if background_name then
			self:print_inverse( "turlututu "..background_name..".tga" )
			bu = bus:add_fond( background_name..".tga", {0,0, sx,sy} )
				bu:set_pos_load_save( false )
				bu.draw = n5_draw_back_text
		end


	--	bus:add_page_buttons()
	--	bus:set_page(0)
	--	bus:trim_page_end()

	--	bus:make_bus_loop()

	bus:init_end()
---[[
	--bus:print_order( "before" )
	if bus.n5_visibility_flip_list then
		bus.n5_visibility_flip_list[2]:move_to_front()
		bus.n5_visibility_flip_list[3]:move_to_front()
		bu_media:set_media_index(2)
		bu_media:set_media_index(1)
	end
	--bus:print_order( "after" )
--]]

	bus:set_method( "update_before",	self,	"update_before"	)
	bus:set_method( "update_after",		self,	"update_after"	)

	return bus
end

function MBRO:add_dir_one( bus, k, name, dir_name_or_table, carton_name )
	local F = .125
	aaa.print_inverse( "N5 adding dir : "..name )
	local bus_down = self:define_pages_inside( name, dir_name_or_table, carton_name )
	bus_down:hide_video()
	local y = math.floor( k / 5 )
	local k = k % 5
	--local bu = bus:add_window( "win "..name, bus_down, {k-2,y, 8*F, 4.5*F} )
	local bu = bus:add_window( "win "..name, bus_down,	{0,0, 8*F,4.5*F} )
	bus_down:set_transfo( 8,4.5 )
	bu:set_border( false )
	--bu:set_border_line( true )
	bu:set_text_draw( false )
	bu:set_ui_top( false )
	set_n5_bu( bu )
	return bu
end
function MBRO:add_dir_in_dir( bus, dir_name )
	local t_dir = aaa.dir.get_dirs( dir_name )
	local nb = 0
	if t_dir then
		dir_name = dir_name.."/"
		for k, name in pairs( t_dir ) do
			local bu = self:add_dir_one( bus, k, name, dir_name..name, dir_name..name )
			if bu then nb = nb + 1  end
		end
	end
	self.__nb_sub_dir = nb
end

function MBRO:define_pages( dir_name )
	local bus = BUS:create( self:get_name() )
	self.bus = bus
	bus:set_bu_pos_load_save( false )
--	self.ui.bus = bus
	bus:set_active( true )
	bus:init_begin()

		self:add_dir_in_dir( bus, dir_name )

	bus:init_end()

--	bus:set_method( "draw_before",	self,	"draw_background"	)
--	bus:set_method( "draw_after",	self,	"draw_foreground"	)

--	ga:register_ui_group( bus )
--	ga:set_ui_group_active( false )
	return bus
end


