
--todo ip and names already in monaco location
MONACO_AQUA.mac_addresses =
{
	{	name = "BERTHA-MAS",	ip = "192.168.1.200",	mac = "2C:F0:5D:08:3E:49"	},
	{	name = "BERTHA-SO",		ip = "192.168.1.205",	mac = "B4:2E:99:84:F4:B3"	},
	{	name = "BERTHA-KC",		ip = "192.168.1.210",	mac = "B4:2E:99:89:7D:47"	},
	{	name = "BERTHA-KL1",	ip = "192.168.1.211",	mac = "E0:D5:5E:D4:7C:54"	},
	{	name = "BERTHA-KL2",	ip = "192.168.1.212",	mac = "B4:2E:99:84:EE:7B"	},
	{	name = "BERTHA-KL3",	ip = "192.168.1.213",	mac = "B4:2E:99:89:7C:5D"	},
	{	name = "BERTHA-KL4",	ip = "192.168.1.214",	mac = "B4:2E:99:84:EC:0B"	},
	{	name = "BERTHA-KR1",	ip = "192.168.1.221",	mac = "B4:2E:99:89:7C:1B"	},
	{	name = "BERTHA-KR2",	ip = "192.168.1.222",	mac = "B4:2E:99:89:7C:4C"	},
	{	name = "BERTHA-KR3",	ip = "192.168.1.223",	mac = "B4:2E:99:89:7C:16"	},
	{	name = "BERTHA-KR4",	ip = "192.168.1.224",	mac = "B4:2E:99:84:F4:50"	},
	{	name = "NUCL1",			ip = "192.168.1.231",	mac = "1C:69:7A:08:1E:4A"	},
	{	name = "NUCL2",			ip = "192.168.1.232",	mac = "1C:69:7A:08:1E:89"	},
	{	name = "NUCL3",			ip = "192.168.1.233",	mac = "1C:69:7A:08:1E:1F"	},
	{	name = "NUCL4",			ip = "192.168.1.234",	mac = "1C:69:7A:08:1D:55"	},
	{	name = "NUCR1",			ip = "192.168.1.241",	mac = "1C:69:7A:06:84:E5"	},
	{	name = "NUCR2",			ip = "192.168.1.242",	mac = "1C:69:7A:08:1E:00"	},
	{	name = "NUCR3",			ip = "192.168.1.243",	mac = "1C:69:7A:08:1E:03"	},
	{	name = "NUCR4",			ip = "192.168.1.244",	mac = "1C:69:7A:08:1E:8E"	},
}

function meu:update_wake()
	self:wake_up_table( app.mac_addresses )
end

function meu:define_ui()
	local ref = self.ref
	local ui = self.ui
	local bu
	local ix = 1
	local iy = 1
	local SY = 1
	local DY = .5
	local SYM = SY * .8

	iy = iy + DY
	self:add_slider(				{ix,iy,		8,SY},	"Flatland_offset_X", 	aaa.ref.draw_focus_offset_x	):set_min_max( 0, 4000 )
	iy = iy + SY + DY
	--was there for test
	--self:add_button(	{		ix,	iy },					"White Screens", 			self, "b_white_screens",		false		)
--	iy = iy + SY + DY
	self:add_trig_method(			{ix,iy+3,	8, SY},	"FULLSCREEN", 			ga, "force_fullscreen"		):set_color_back( "restart" )

	iy = 8 + 1
	ui.bu_mute = self:add_button(	{ix,iy,		SY,SY},	"Mute", 				nil, nil,			false		):set_method_on_click( self, "mute_volume" )
--	bu = self:add_button(	{"Muet",		1 },	iy,			SY,SY )
--	bu:set_method_on_click( self, "mute_volume" )

	iy = iy + 1
	self:add_slider(				{ix,iy,		8,SY},	"Master Volume", 		self, "master_volume", .9, .0, 1.0	)


	ix,iy = 9, 1
	iy = self:add_exploitation_start_stop(	{ix,iy,	8,SY}, true, true )

	self:add_ui_exploitation_window({ix,iy,		8,SY}	)
	iy = iy + 5

end

function meu:init()
	local ref = self.ref
--	local bdd = self:get_layer_bdd(1)
--	ref.temp	= param.get_ref( bdd, "received_number_last" )
	self.s_fullscreen_needed = 0
	self.last_master_volume = -1.0
end

function meu:update_ui()
	self:update_ui_exploitation_start_stop()
end

function meu:mute_volume()
	local b_mute = self.ui.bu_mute:get_value_as_bool()
	self:print( "Mute Sound "..b_mute )

	if app and app.mute_sound then
		app:mute_sound( b_mute )
		if not b_mute then
			if app and app.set_volume_master then
				app:set_volume_master( self.master_volume )
			end
		end
	end
end

function meu:update()
	local b_onsite = not aaa.pc.is_maa() or not app:is_pc_dev()
	-- check if master volume has changed
	if self.last_master_volume ~= self.master_volume then
		self.last_master_volume = self.master_volume
		if app and app.set_volume_master then
			app:set_volume_master( self.master_volume )
		end
	end

	if b_onsite or self.b_onsite_force then
		self:update_exploitation_start_stop( true, true )
	end

	self:update_exploitation_window()
end