-- function meu:define_ui()
-- 	local ref = self.ref
-- 	local ui = self.ui
--     local ix,iy = 1,1
--     local SY,DY = 1,.2

--     self:add_rendering()    --todo why we get remdering from layer_c ???
-- 	self:add_camera()
--     ix, iy = 9, 2 + DY

--     local bu = self:add_slider( {1,2, 8,1}, "Test", self, "size", 1, 0,8 )
-- --  self:add_transfo( {ix,iy,   8,2.4} )
-- --    iy = iy + 2.4 + DY
-- end

function meu:init()
    
end

function meu:define_ui()
    local ref = self.ref
    local ui = self.ui
    local bu = self:add_trig_method({1, 2, 8, 1}, "Test", self, "net_request")
end

function meu:draw()
    self:draw_layers_begin()
        --  self:print( aaa.time.t )
        self:draw_layer( 1 )
        self:draw_1( self:get_alpha(), 5, false )       -- choose the drawing function here
    self:draw_layers_end()
end

function meu:net_request()
    self:print("DOING REQUEST")
    local blapurl = "http://www.aaaseed.org/"
    local r, c, h, s = aaa.socket.http.request{url=blapurl, sink=aaa.ltn12.sink.file(io.stdout)}
end

-- documentation is in
--  AAADoc/lua_aaaseed_draw.lua
--  AAADoc/lua_aaaseed_interface.lua

-- Hello world
function meu:draw_1( alpha )
    gol.color_white( alpha )
    aaa.draw_str( "Bonjour\nil est "..os.date("%H:%M:%S") )
end


-- Flash
function meu:draw_2( alpha ) 
    gol.color_white( (math.sin(aaa.time.t * 10.) * .5 + .5) * alpha )
    aaa.draw_str( "Flash" )
end

-- Rectangle
function meu:draw_3( alpha )
    gol.color_green( alpha )
    aaa.draw_rect_line( -1,-1, 2,2 )
end

-- Rectangles
function meu:draw_4( alpha, nb_factor )
    gol.color_yellow( alpha )
    local nb = 100 * nb_factor
    local size = 8
    local d = size/(nb-1)
    math.randomseed(42)
    for i=1,nb do
        local x = -size/2 + size * (i-1)/(nb-1)
        aaa.draw_rect_line( x,0, x+d,math.random()*2 )
    end
end

-- more Rectangles
function meu:draw_5( alpha, nb_factor )
    local nb_y = 8 * nb_factor
    local size_y = 8
    local d_y = size_y/(nb_y-1)

    local nb_x = 8 * nb_factor 
    local size_x = 8
    local d_x = size_x/(nb_x-1)
    math.randomseed(42)

    for iy=1,nb_y do
        local y = -size_y/2 + size_y * (iy-1)/(nb_y-1)
        for ix=1,nb_x do
            local x = -size_x/2 + size_x * (ix-1)/(nb_x-1)
            local rnd = math.random()
            --rnd = math.pow( rnd, 4 ) * 4.
            local d = rnd * d_y * .5
            d = d * (math.sin( -aaa.time.t * 5. + iy / 3. ) * .25 + .75 )
            local r,g,b = math.random(), math.random(), math.random()
            gol.color( r,g,b, alpha )  -- red green blue alpha
            --gol.color( r*rnd, g*rnd, b*rnd )
            aaa.draw_rect( x-d,y-d, x+d,y+d)
        end
    end
    
end

-- Some 3d
local function get_color()
    local r = math.random()
    local g = math.random()
    local b = math.random()
    local gam = 1.
    return math.pow(r,gam), math.pow(g,gam), math.pow(b,gam)
end

function meu:draw_6( alpha, nb_factor, b_rotate )
    local nb = 160 * nb_factor * nb_factor
    local size = 8
    math.randomseed(42)

    for i=1,nb do
        local x = size * (math.random() - .5)  
        local y = size * (math.random() - .5)  
        local z = size * math.random() * .1
        local r,g,b = get_color()
        gol.color( r,g,b, alpha )
         --gol.color( r*rnd,g*rnd,b*rnd )
        gol.push_matrix()
            gol.translate( x,y,z )
            if b_rotate then
                gol.rotate_y( math.random() )
                gol.rotate_x( math.random() )
            end
            local s = .5
            local sx = math.random() * s
            local sy = math.random() * s
            local sz = math.random() * s       
            aaa.draw_box( sx,sy,sz )
        gol.pop_matrix()
    end

end