function meu:define_ui()
	local ref = self.ref
	local bu

	local ix,iy = 1,1
	local SY = 1.5
	local DY = .5 

	self:add_slider( {ix,iy, 	4,SY},	"A",	self, "v_a", 	0 )
	self:add_slider( {ix+4,iy, 	4,SY},	"B",	self, "v_b", 	0 )
	iy = iy + SY + DY

	self:add_button( {ix+2,iy, 	4,SY},	"Map",	self, "b_map", false )
	iy = iy + SY + DY

	self:add_slider( {ix+2,iy, 	4,SY},	"Overlap",	self, "overlap", 0 )
	iy = iy + SY + DY

	self:add_button( {ix+2,iy, 	4,SY},	"Fuzzy",	self, "b_fuzzy", false )
	iy = iy + SY + DY

	self:add_slider( {ix+2,iy, 	4,SY},	"Gamma",	self, "gamma", .5,	0,4 )
	iy = iy + SY + DY

end

function meu:update()
	self.frame_count = (self.frame_count or 0) + 1
	--self:print( "frame_count"..self.frame_count )
	if self.frame_count==5 then
		self.out_a = self:get_meu_by_name( "Out_FuzzyA" )
		self.out_b = self:get_meu_by_name( "Out_FuzzyB" )
	end
	if not self.out_a then
		return
	end
	
	self.out_a:set_mu_value( self.v_a )
	self.out_b:set_mu_value( self.v_b )

	self.out_a:set_bu_value( "Type", self.b_map and 3 or 2 )
	self.out_b:set_bu_value( "Type", self.b_map and 3 or 2 )

	param.set( self.out_a.ref.bdd, "center_x",  interpolate(-2,-1,self.overlap) )
	param.set( self.out_b.ref.bdd, "center_x",  interpolate(2,1,self.overlap) )

	self.out_a:set_bu_value( "Fuzzy", self.b_fuzzy )
	self.out_b:set_bu_value( "Fuzzy", self.b_fuzzy )

	self.out_a:set_bu_value( "gamma", self.gamma )
	self.out_b:set_bu_value( "gamma", self.gamma )

end