
function meu:define_ui()
	local ref = self.ref
	local bu
	local ix = 1
	local iy = 1
	local SY = 1
	local DY = .25

	self:add_button(	{	ix,	iy,		4, 1 },	"Presence", 		self, "b_presence",		true 		)
	bu = self:add_slider(	{ix,iy+1,	8,1},	"Presence Out", 	self, "presence_out",			0, 0, 1		)
		bu:set_value_load_save( false )
	iy = iy + SY
	bu = self:add_slider(	{ix,iy+1,	8,1},	"Center U", 	self, "center_u",			0, 0, 1		)
		bu:set_value_load_save( false )
	iy = iy + SY
	bu = self:add_slider(	{ix,iy+1,	8,1},	"Center V", 	self, "center_v",			0, 0, 1		)
		bu:set_value_load_save( false )
	iy = iy + SY*2 + DY

	self:add_button(	{	ix,	iy,		4, 1 },	"Colors", 			self, "b_colors",		true 		)
	iy = iy + SY + DY

	ix, iy = 9, 1
	self:add_slider(	{ix,iy,	8,SY},	"Flatland X", 			aaa.ref.draw_focus_offset_x	):set_min_max( 0, 4000 )
	iy = iy + SY + DY
	iy = self:add_exploitation_start_stop(	{ix,iy,	8,SY}, false, false )
	iy = iy + DY

	self:add_ui_exploitation_window(	{ix,iy,	8,SY*5 })
	iy = iy + SY*5

end

function meu:init()
	local ref = self.ref
	
	ref.bdd_anal = self:get_layer_bdd(1)
	ref.cov_out = param.get_ref( ref.bdd_anal, "out_coverage" )
	ref.center_u = param.get_ref( ref.bdd_anal, "out_center_u" )
	ref.center_v = param.get_ref( ref.bdd_anal, "out_center_v" )
	ref.time_factor = param.get_ref( aaa.ref.app, "time_factor" )
	local obj = aaa.obj.get_from_top_by_class( "master_boid" )
	ref.dist_scale = param.get_ref( obj, "distance_scale" ) 
	param.set_save( ref.time_factor, false )
end

function meu:update_colors()
	local meu_tank = self:get_meu_by_name_cached( "TankFish_1" )
	if not meu_tank then return end

	local meu_colors = self:get_meu_by_name_cached( "Colors_1" )
	if not meu_colors then return end

	local tank = meu_tank:get_tank()
	local ggrea = tank:get_ggrea()

	if ggrea then
		local nb = ggrea:get_grea_nb()
		for i=1,nb do
			--self:print( "Toto "..i )
			local grea = ggrea:get_grea_by_id( i )
			--self:print( grea.." Toto "..i )
			local r,g,b, a = meu_colors:get_rgba( i )
			grea:set_boid_rgba( r,g,b, a )
		end
	end
end

function meu:update()
	--if not aaa.pc.is_maa() then

	if self.b_presence then
		self.presence_out = param.get( self.ref.cov_out )
		self.center_u = param.get( self.ref.center_u )
		self.center_v = param.get( self.ref.center_v )
		
		local u,v
		if self.presence_out > 0. then
			v = clamp_01( .0 + (1-self.center_v) * 1.2 )
			u = clamp_01( self.center_u ) * 2.
		else
			v=.2
			u=1
		end
		param.set( self.ref.time_factor, v )
		param.set( self.ref.dist_scale, u )
	end

	self:update_exploitation_start_stop_shutdown()
	self:update_exploitation_window()

	if self.b_colors then
		self:update_colors()
	end
end

function meu:draw()
	if self.b_presence then
		MEU.draw(self)
	end
end