
function meu:define_ui()
	local ref = self.ref
	local bu
	local ix = 1
	local iy = 1
	local SY = 1
	local DY = .25

	self:add_button(		{ix,iy,		4,1},	"Presence", 		self, "b_presence",		true 		)
	bu = self:add_slider(	{ix,iy+1,	8,1},	"Presence Out", 	self, "presence_out",	0,	0,1		)
		bu:set_value_load_save( false )
	iy = iy + SY*2 + DY

	self:add_button(		{ix,iy,		4,1},	"Colors", 			self, "b_colors",		true 		)
	iy = iy + SY + DY

	self:add_button(		{ix,iy,		4,1},	"Fish Cam", 		self, "b_fish_cam", 	false		)
	self:add_trig_method(	{ix+4,iy,	3,1},	"Pick", 			self, "attach_cam"					):set_color_back( "restart" )
	iy = iy + SY + DY

	ix, iy = 9, 1
	self:add_slider(		{ix,iy,		8,SY},	"Flatland X", 		aaa.ref.draw_focus_offset_x	):set_min_max( 0, 4000 )
	iy = iy + SY + DY
	iy = self:add_exploitation_start_stop(	{ix,iy,	8,SY}, false, false )
	iy = iy + DY

	self:add_ui_exploitation_window(	{ix,iy,	8,SY*5 })
	iy = iy + SY*5

end

function meu:init()
	local ref = self.ref
	
	ref.bdd_anal = self:get_layer_bdd(1)
	ref.cov_out = param.get_ref( ref.bdd_anal, "out_coverage" )
	ref.time_factor = param.get_ref( aaa.ref.app, "time_factor" )
	param.set_save( ref.time_factor, false )
end

function meu:update_colors()
	local meu_tank = self:get_meu_by_name_cached( "TankFish_1" )
	if not meu_tank then return end

	local meu_colors = self:get_meu_by_name_cached( "Colors_1" )
	if not meu_colors then return end

	local tank = meu_tank:get_tank()
	local ggrea = tank:get_ggrea()

	if ggrea then
		local nb = ggrea:get_grea_nb()
		for i=1,nb do
			--self:print( "Toto "..i )
			local grea = ggrea:get_grea_by_id( i )
			--self:print( grea.." Toto "..i )
			local r,g,b, a = meu_colors:get_rgba( i )
			grea:set_boid_rgba( r,g,b, a )
		end
	end
end

function meu:pick_crea_cam()
	aaa.print_fn()
	-- TANK:get_grea_nb()
	-- TANK:get_grea_by_id( id )
	if not self.cam_hook then
		local m = self:get_meu_by_name_cached( "Fbo_GBuffer" )
		self.cam_hook = m:get_camera( 7 )
	-- 	--self:print( "Camera is "..self.cam_hook )
	end
	local cam = self.cam_hook

	if not self.tank then
		local m = self:get_meu_by_name_cached( "TankFish_1" )
		self.tank = m:get_tank()
		--self:print( "Tank is "..self.tank )
	end
	local tank = self.tank

	self.crea = tank:set_crea_hook_candidate()
	-- else
	if self.crea then
		tank.pt_hook_pos:set_factor(.01)
		tank.pt_hook_target:set_factor(.01)
	end
end

function meu:update_exo_1()
	local m = self:get_meu_by_name_cached( "NdcFog_1" )
	m:set_bu_value( "sun dir_x", math.sin(aaa.time.t * .1) )

	m = self:get_meu_by_name_cached( "NdcJumpFlood_F14" )
	local s = .05
	m:set_bu_value( "dist max",		( aaa.math.get_turbulence( 0,0,			aaa.time.t*.1,		1, 3 ) + .5) * s )
	m:set_bu_value( "top_factor",	( aaa.math.get_turbulence( 3.1,1.45,	aaa.time.t*.08,		1, 3 ) + .5) * .6 + .6 ) 
	m:set_bu_value( "top_src",		( aaa.math.get_turbulence( -3.1,2.43,	aaa.time.t*.0777,	1, 3 ) + .5) * .6+ 1.2 ) 
	m:set_bu_value( "v to l",		( aaa.math.get_turbulence( .25,1.23,	aaa.time.t*.06646,	1, 3 ) + .5) * 1  ) 
end
function meu:update_ui()
--	self:print( "app.media_dir_rel is "..app.media_dir_rel )
end

function meu:update()
	self:update_exo_1()
	--if not aaa.pc.is_maa() then

	if self.b_fish_cam then
		if not self.crea then
			self:pick_crea_cam()
		end
		if self.crea then
			self.tank:place_camera_hooked( self.cam_hook, self.crea )
		end
	end

	if self.b_presence then
		self.presence_out = param.get( self.ref.cov_out )
		local v = clamp_01( .25 + self.presence_out * 1.5 )
		param.set( self.ref.time_factor, v )
	else
		param.set( self.ref.time_factor, 1/16 )
	end

	self:update_exploitation_start_stop_shutdown()
	self:update_exploitation_window()

	if self.b_colors then
		self:update_colors()
	end
end

function meu:draw()
	if self.b_presence then
		MEU.draw(self)
	end
end